/*
 * Decompiled with CFR 0.152.
 */
package pt.caf_pbs.schooldiskapi.model;

import java.io.Serializable;
import pt.caf_pbs.schooldiskapi.exceptions.InvalidDataException;
import pt.caf_pbs.schooldiskapi.model.LectureContainer;
import pt.caf_pbs.schooldiskapi.model.Person;

public class Instructor
extends Person
implements Serializable {
    private String initials;
    private LectureContainer lectures = new LectureContainer();

    public Instructor(String initials, String name) {
        super(name);
        this.setInitials(initials);
    }

    private boolean isInitialsValid(String initials) {
        return initials.length() == 4;
    }

    public String getInitials() {
        return this.initials;
    }

    public void setInitials(String initials) {
        if (!this.isInitialsValid(initials)) {
            String msg = "Instructor: " + initials;
            throw new InvalidDataException(msg);
        }
        this.initials = initials;
    }

    public LectureContainer getLectures() {
        return this.lectures;
    }

    public void setLectures(LectureContainer lectures) {
        this.lectures = lectures;
    }

    public boolean isEqualTo(Instructor obj) {
        return this.initials.equals(obj.initials);
    }

    public boolean isEqualTo(String initials) {
        return this.initials.equals(initials);
    }
}

